# Формат JSON

В данном разделе описан JSON-формат передачи метрик в Solomon.

## Описание JSON-формата Solomon {#schema}

Содержимое запроса, передающего метрики в JSON-формате, должно быть валидным [JSON-объектом](http://www.json.org/): не допускаются висячие запятые (trailing comma) и значения `NaN`. Вместе с данными необходимо передавать заголовок, определяющий формат `Content-Type: application/json`.

Схема JSON-формата, использующегося в Solomon, описана в Листинге 1.

<small>Листинг 1 — Схема JSON-формата передачи метрик.</small>

```json
{
  "ts": "string",
  "commonLabels": "object",
  "metrics": [
    {
      "labels": "object",
      "type": "string",
      "mode": "string",
      "memOnly": true,
      "ts": "string",
      "value": "number",
      "hist": {
        "bounds": "object",
        "buckets": "object",
        "inf": "number"
      },
      "timeseries": [
        {
         "ts": "string",
         "value": "number"
        }
      ]
    }
  ]
}
```

Описание полей, использующихся в JSON-формате Solomon, приведено в Таблице 1.

<small>Таблица 1 — Поля и их описания JSON-формата.</small>

Поле | Описание
:----|:--------
ts | **string**(date-time)<br/>Общая временная метка для всех метрик. Допустимые форматы:<br/><ul><li>ISO 8601 с точностью до секунд в UTC. Например: `"ts": "2017-08-27T14:50:21Z"`;</li><li>Unix timestamp. Например: `"ts": 1503923187`.</li></ul>Необязательное поле. Если не указано, используется время получения данных в Solomon (с округлением по [сетке](../../concepts/grid.md), если она включена в проекте).
commonLabels | **object**<br/>Словарь с общими для всех метрик метками. Поле не может содержать метки `project`, `cluster` и `service`, так как они являются зарезервированными.
metrics[] | **object**<br/>Список метрик.
metrics[].labels | **object**<br/>Словарь с метками метрики. Поле не может содержать метки `project`, `cluster` и `service`, так как они являются зарезервированными.
metrics[].type | **string**<br/> Тип метрики. Необязательное поле. Если не указано, используется значение по умолчанию — `DGAUGE`. Подробнее в разделе [{#T}](../../concepts/data-model.md#metric-kinds).
metrics[].mode | **string**<br/><span style="color: red;">DEPRECATED. Вместо поля `mode` следует использовать поле `type`.</span><br/><span style="color: gray;">Тип метрики, единственное поддерживоемое значение — `deriv`. Запись `"mode": "deriv"` эквивалентна записи `"type": "RATE"`.</span>
metrics[].memOnly | **boolean**<br/><span style="color: red;">DEPRECATED. Поле больше не используется.</span><br/><span style="color: gray;">Указывает будет ли метрика храниться только в оперативной памяти и использоваться только для расчета агрегатов или будет записана в долговременное хранилище.</span>
metrics[].ts | **string**(date-time)<br/>Временная метка.<br/><br/>Допустимые форматы:<br/><ul><li>ISO 8601 с точностью до секунд в UTC. Например: `"ts": "2017-08-27T14:50:21Z"`;</li><li>Unix timestamp. Например: `"ts": 1503923187`.</li></ul>Допустимый диапазон значений: между `2000-01-01T00:00:00Z` и `2038-01-19T03:14:07Z` включительно.<br/><br/>Значение поля имеет приоритет перед значением, указанным в глобальном поле `ts`. Необязательное поле. Если не указано, используется время получения данных в Solomon (с округлением по [сетке](../../concepts/grid.md), если она включена в проекте). Если указано, является взаимоисключающим с полем `metrics[].timeseries[]`.
metrics[].value | **number**<br/>Обязательное поле. Значение метрики в указанной временной точке. Является взаимоисключающием с полем `metrics[].timeseries[]`.
metrics[].hist | **object**<br/>Объект со значением гистограмной метрики. Обязательно поле только для типов метрик `HIST` и `HIST_RATE`.
metrics[].hist.bounds[] | **object**<br/>Список с **верхними** границами интервалов гистограммы. Допустимо использовать дробные значения. Значения должны быть упорядочены по возрастанию. Максимальное количество - 50
metrics[].hist.buckets[] | **object**<br/>Список значений с количеством значений наблюдаемой величины, попавших конкретный интервал гистограммы. Количество элементов в списке должно совпадать с количеством элементов в списке **bounds**.
metrics[].hist.inf | **number**<br/>Количество элементов, оказавшихся за пределами верхней границы последнего интервала гистограммы. Необязательное поле. Если не указано, используется 0.
metrics[].timeseries[] | **object**<br/>Список из нескольких значений метрики в разных временных точках. Список должен быть упорядочены по возрастанию значений поля `ts`. Является взаимоисключающим с полямии `metrics[].ts` и `metrics[].value`.
metrics[].timeseries[].ts | **string**(date-time)<br/>Временная метка.<br/><br/>Допустимые форматы:<br/><ul><li>ISO 8601 с точностью до секунд в UTC. Например: `"ts": "2017-08-27T14:50:21Z"`;</li><li>Unix timestamp. Например: `"ts": 1503923187`.</li></ul>Допустимый диапазон значений: между `2000-01-01T00:00:00Z` и `2038-01-19T03:14:07Z` включительно.<br/><br/>Значение поля имеет приоритет перед значением, указанным в глобальном поле `ts`.
metrics[].timeseries[].value | **number**<br/>Значение метрики в указанной точке.

## Пример JSON-представления {#example}

В Листинге 2 приведен пример JSON-представления следующего набора метрик:
* GAUGE-метрика `{name="memory"}` со значением 10;
* GAUGE-метрика `{name="queue_size", export="oxygen"}` со значением 335.7;
* RATE-метрика `{name="requests_per_second"}`, значение которой будет вычислено как производная между значением 7000 и предыдущим значением;
* IGAUGE-метрика `{name="memory.usage_bytes"}` со значением 655350;
* DGAUGE-метрика `{name="cpu.temperatere_celsius"}` со значением 78.9;
* HIST_RATE-метрика `{name="response_time_millis"}`, значение которой для каждого интервала из набора `[10, 20, 40, 80, 160, 320, 640, 10240]` будет вычислено как производная между соответствующим значением `[0, 1, 0, 100, 0, 2, 0, 0]` и значением интервала в предыдущей точке;
* DGAUGE-метрика `{name="writes"}` с двумя значениями: в точке `2017-08-28T01:23:45Z` – 10 и в точке `1503923187` в 20.

<small>Листинг 2 — Пример содержимого запроса, передающего метрики в JSON-формате.</small>

```json
{
  "metrics": [
    {
      "labels": { "name": "memory" },
      "value": 10
    },
    {
      "labels": { "export": "oxygen", "name": "queue_size" },
      "value": 335.7
    },
    {
      "labels": { "name": "requests_per_second" },
      "type": "RATE",
      "value": 7000
    },
    {
      "labels": { "name": "memory.usage_bytes" },
      "type": "IGAUGE",
      "value": 655350
    },
    {
      "labels": { "name": "cpu.temperatere_celsius" },
      "type": "DGAUGE",
      "value": 78.9
    },
    {
      "labels": { "name": "response_time_millis" },
      "type": "HIST_RATE",
      "hist": {
        "bounds": [10, 20, 40, 80, 160, 320, 640, 10240],
        "buckets": [0, 1, 0, 100, 0, 2, 0, 0],
        "inf": 0
      }
    }
    {
      "labels": { "name": "writes" },
      "timeseries": [
        {
          "ts": "2017-08-28T01:23:45Z",
          "value": 10,
        },
        {
          "ts": 1503923187,
          "value": 20,
        }
      ]
    }
  ]
}
```
