# Push-режим передачи метрик

В push-режиме передачи метрик запрос к Solomon инициирует пользовательское приложение. Push-режим подходит для передачи небольших объемов данных (до 10 000 точек в секунду) и удобен, например, для сбора метрик с периодически запускающихся stateless-процессов или скриптов. При этом push-режим требует дополнительного логирования на клиенте для диагностики ошибок, а также обладает рядом ограничений и особенностей, описанных ниже.

## Push в Solomon API {push-api}

Для передачи метрик в push-режиме напрямую в Solomon API используется POST-метод `/api/v2/push` приватного [{#T}](../api-ref/rest.md). Адреса подключения к API для каждого из кластеров Solomon перечислены в разделе [{#T}](../overview/clusters.md).

Для идентификации шарда, в который будут записаны метрики, в одноименных обязательных параметрах указываются значения меток `project`, `cluster` и `service` (не идентификаторы соответствующих объектов конфигурации, а значение параметра *Label name*, как показано на Рисунке 1). Значения метрик передаются в теле POST-запроса. Пример запроса к Solomon Push API приведен в Листинге 1.

{% note warning %}

В метках, передающихся в поле `labels` в теле POST-запроса, запрещено использовать метки `project`, `cluster` и `service`.

{% endnote %}

![Параметр Label name на странице сервиса](_assets/label-name.png "Параметр Label name на странице сервиса"){ width="1552" }
<small>Рисунок 1 — Параметр *Label name* на странице сервиса.</small>

<small>Листинг 1 — Пример запроса к Solomon Push API при помощи утилиты cURL.</small>

```bash
curl https://solomon.yandex.net/api/v2/push?project=junk&cluster=foo&service=bar \
  -X POST \
  -H "Content-Type: application/json" \
  -H "Authorization: OAuth ${SOLOMON_TOKEN}" \
  --data '{
    "commonLabels": {
      "host": "solomon-push"
    },
    "metrics": [
      {
        "labels": { "sensor": "Memory" },
        "ts": "2014-11-10T13:14:15Z",
        "value": 456
      },
      {
        "labels": { "sensor": "Memory" },
        "ts": 1415631708,
        "value": 463
      }
    ]
  }'
```

### Формат данных {#data-format}

При выполнении push-запросов необходимо указывать заголовок *Content-Type*, указывающий какой формат исползьуется для передачи метрик. Доступные значения заголовка перечислены в Таблице 1.

<small>Таблица 1 — Значение заголовка *Content-Type* для разных форматов данных.</small>

Формат данных|Значение заголовка *Content-Type*
-------------|------------------
[JSON](../data-collection/dataformat/json.md) | `application/json`
SPACK | `application/x-solomon-spack`

### Ограничения {#restrictions}

Помимо ограничений, накладываемых [моделью данных](../concepts/data-model.md#limits), Push API имеет следующие ограничения:
* В Push API **не поддерживаются** [типы метрик](../concepts/data-model.md#metric-kinds) `RATE` и `HIST_RATE`. При их отправке возникнет ошибка `DERIV_AND_TS`.
* Поле `labels` не может содержать метки `project`, `cluster` и `service` – их следует передавать в параметрах URL, по которому выполняется POST-запрос.
* В одном запросе к Push API возможно передать значения не более, чем 10 000 метрик. Для передачи значений большего количества метрик необходимо использовать несколько запросов.


### Изменение данных {#rewrite}

При помощи Push API возможно перезаписывать уже записанные значения метрик или, например, загрузить в Solomon исторические данные, передавая новые значения с временной меткой в прошлом.

В таком случае, если в шарде используется [агрегация при записи](../concepts/aggregation.md#aggregation-on-write), то к существующим меткам-агрегатам будет добавлено новое значение, так как агрегаты работают по принципу аккумулятора. В Таблице 1 приведен пример перезаписи значения через Push API.

<small>Таблица 2 — Пример перезаписи значения через Push API.</small>

Метрика | Временная метка | Старое значение | Новое значение |
--------|-----------------|-----------------|----------------|
`error.count{host="solomon=000"}` | 2020-07-08 10:37:30 | 10 | 15 |
`error.count{host="cluster"}`<br/><small>(метрика-агрегат)</small> | 2020-07-08 10:37:30 | 100 | 100+15=115 |

{% note warning %}

Аналогичный эффект накопления значений в агрегатах возможен при повторных попытках выполнения одного и того же Push-запроса в случае возникновения ошибки. В следующих версиях Solomon планируется поддержать идемпотентность в Push-запросах, чтобы нивелировать этот эффект, приводящий к ложным пикам на графиках агрегатов.

{% endnote %}

### Выравнивание по сетке {#push-and-grid}

{% include notitle [Выравнивание по сетке](../_includes/grid.md) %}

### Обработка ошибок {#push-errors}

При выполнении запросов к Push API, содержащих большое количество данных, API может отвечать в течение 10-15 секунд. В случае, если выполнение запроса было прервано по таймауту, API возвращает код 504, сигнализирующий о том, что запрос следует повторить.

Если запрос содержит метрики, чьи метки не соответствуют [ограничениям модели данных](../concepts/data-model.md#limits), то он все равно будет обработан, и API вернет успешный код ответа. При этом в Solomon будут записаны значения только тех метрик, чьи метки соответствуют ограничениям. Рекомендуется проверять количество записанных метрик и сравнивать его с количеством передаваемых метрик, чтобы своевременно узнать об ошибках записи.

Чтобы проверить наличие ошибок записи через Push API в какой-либо шард, откройте страницу шарда в интерфейсе [Admin UI](https://solomon.yandex-team.ru/admin), а затем перейдите по ссылке *Shard Status* и откройте вкладку *Processing*. Если график *Metrics parse errors* отсутствует (вместо него отображается предупреждение *No lines found*) или все линии на графике показывают нулевые значения, значит ошибок записи в шард нет. Описания ошибок и рекомендации по их устранению приведены в разделе [{#T}](../operations/metrics/troubleshooting.md#push-shard-status).

![Графики с количеством ошибок при записи метрик через Push API на странице шарда](_assets/metrics-parse-errors-empty.png "Графики с количеством ошибок при записи метрик через Push API на странице шарда"){ width="1552" }
<small>Рисунок 2 — Графики с количеством ошибок при записи метрик через Push API на странице шарда.</small>


### Клиенты {#push-clients}

В данном разделе приведены ссылки на клиенты к Push API для различных языков программирования.

{% list tabs %}

- C++

  C++-клиент к Push API расположен в Аркадии в директории [library/cpp/monlib/push_client](https://a.yandex-team.ru/arc/trunk/arcadia/library/cpp/monlib/push_client).

- Java

  Java-клиент к Push API расположен в Аркадии в директории [iceberg/inside-solomon](https://a.yandex-team.ru/arc/trunk/arcadia/iceberg/inside-solomon).

- Python

  Python-клиент к Push API расположен в Аркадии в директории [library/python/solomon](https://a.yandex-team.ru/arc/trunk/arcadia/library/python/solomon).

{% endlist %}
