# FAQ
В этом разделе можно найти ответы на часто возникающие вопросы.

## Сбор данных

### Можно ли переименовывать метрики?
Нет, переименовывать метрики нельзя. Переименованные метрики будут восприниматься мониторингом как новые.

### Можно ли поменять тип передаваемой метрики?

Да, можно. Старые данные при этом не будут изменены.

То есть если вы присылали COUNTER, а потом изменили метрику на RATE, исторические данные останутся со значениями COUNTER.

### Можно ли использовать pull и push в одном шарде?
Да, можно.

### Какой TTL в мониторинге используется по умолчанию?
По умолчанию [TTL](concepts/deletion/ttl.md) выключен.

### Можно ли включить TTL для групповых данных YASM?
Нет, нельзя, так как это [приводит к побочным эффектам](concepts/deletion/ttl.md#yasm-ttl).

### Почему в метриках автоматически не проставляется метка `host`?

Вероятнее всего, в ответе серверу присутствует пустая метка `host`. Её необходимо убрать, чтобы сервер сам проставлял имя хоста в метку `host`.

### Как удалить точки на графике?
В мониторинге нет специального механизма для удаления отдельных точек, можно удалить только [метрики целиком](concepts/deletion/operation.md).

При необходимости удалить отдельные точки это можно сделать следующим образом:
1. Выгрузить все точки, используя [API](api-ref/rest.md);
2. Удалить ненужные точки в выгруженных данных;
3. Удалить метрики;
4. Загрузить скорректированные данные обратно через API.
5. Следует учесть, что повторная запись ранее существовавших значений приведёт к тому, что вновь записываемое значение будет повторно прибавлено к [агрегатам](concepts/aggregation.md#aggregation-on-write), если они настроены.

### Что означает ошибка "unknown service provider" при push? {#unknown-service-provider}
В облачной инсталляции Solomon по умолчанию можно отправлять метрики только в шарды с service=custom или service, равным одному из идентификаторов существующих сервис-провайдеров. Чтобы получить возможность использовать любые service, как во внутренней инсталляции, необходимо создать тикет в очереди MONITORINGREQ с формулировкой "Пометить облачный проект как internal", указав идентификатор проекта (облака).

## Просмотр метрик

### Можно ли создать график по данным из другого проекта?
Да, можно, используя интерфейс [Monitoring UI](https://monitoring.yandex-team.ru).

### Почему неделю назад появился резкий скачок на графике?
Это может быть связано с особенностями [семплирования и прореживания исторических данных](concepts/downsampling.md#downsampling-with-decimation).

### Почему не отображаются некоторые точки в RATE-метриках?
В метриках типа RATE не отображается первая точка. Это связано с тем, что первое значение не с чем сравнивать. Поэтому значения отображаются начиная со второй точки. Чтобы это исправить, необходимо инициализировать первую точку на стороне клиента. Пример передаваемых и записываемых значений RATE-метрики можно посмотреть [в таблице](concepts/data-model.md#rate).

## Язык запросов

### Почему не работают функции агрегации max/min/sum/avg/count?
Функции агрегации не будут работать в том случае, если вы пытаетесь применить их к нескольким временным рядам. Они могут работать с вектором, но в этом случае вектор метрик должен содержать только один временной ряд. Более подробную информацию смотрите [в документации](concepts/querying.md#aggregation-functions).

### Что означает ошибка "Too many metrics are loaded by selectors"?
Это значит, что вы задали слишком общий запрос, в который попало более [10000 метрик](concepts/limits.md#expression-limits). Необходимо уточнить запрос.

### Как в запросе или в программе алерта обратиться к значению метки?

Для этого существует функция ["get_label"](concepts/querying.md#get_label).

## Алертинг

### Что делать при возникновении ошибки "Max metrics to load limit exceeded: 100"?

Сумма метрик, обрабатываемых всеми выражениями алерта не должна превышать 100. Можно воспользоваться следующими рекомендациями, чтобы обойти это ограничение:

1. Сократить количество метрик, обрабатываемых алертов, настроив [агрегацию при записи](concepts/aggregation#aggregation-on-write) и использовав в алерте агрегат.
2. Настроить [мульти-алерт](concepts/alerting/#multi-alerts). Ограничение в 100 метрик будет применяться для в каждого под-алерта.
3. Если агрегация last и sum не подходит, или агрегация не нужна, то можно преобразовать метрику в [гистограмму](https://docs.yandex-team.ru/solomon/concepts/data-model#hist), и использовать в алерте [функции комбинирования](https://docs.yandex-team.ru/solomon/concepts/querying#combination) для гистограмм. 

### Можно ли настроить алерт по метрикам из другого проекта?
Да, можно. Подробную инструкцию можно посмотреть в [документации](concepts/alerting/index.md#cross-project).

### Почему не применяется шаблон в мультиалерте?
Шаблоны в мультиалертах пока что [не поддерживаются](concepts/alerting/index.md#templates). Они будут проигнорированы мониторингом.

### Как сделать алерт на квоту в YT? {#yt-quota}

Воспользуйтесь [общим механизмом](https://docs.yandex-team.ru/yt/best_practices/quota_monitoring), который предоставляет команда YT.

### Что отображается на графике Alert chart на экране просмотра алерта?

#### Заголовок
В заголовке графика Alert chart отображается результат выполнения программы алерта — либо на момент открытия алерта, либо, если использовать столбики из график Alert evaluation status для навигации по времени — на время, указанное в столбике.

Если кликнуть в столбик графика Alert evaluation status со временем 11:15:00, то сервер выполнит _текущую_ программу алерта так, как если бы она выполнялась в 11:15:00 — на данных с учётом размера окна и сдвига. Например, для алерта с окном в 5 минут и сдвигом на 1 минуту, клик в столбик 11:15:00 загрузит данные с 11:09 по 11:14 и выполнит на них программу алерта.

{% note info %}

Фактический расчёт статуса алерта может выполняться на отличных от Alert chart данных. Этому есть две причины:

1\. Расчёт алертов и сабалертов выполняется с [джиттером](https://ru.wikipedia.org/wiki/Джиттер) в течение минуты, используя окно относительно своего времени запуска. Алерт с окном в 1 минуту, рассчитываемый в 11:15:47, возьмёт данные за 1 минуту с 11:14:47 до 11:15:47.

2\. При расчёте алерта через веб-интерфейс используются те данные, которые находятся в хранилище в _момент просмотра_. При редких случаях, когда клиент сильно задерживает поставку данных или поставляет их "в прошлое", могут быть ситуации, когда алерт выполняется на одних данных, а при просмотре через веб-интерфейс за то же самое время програма выполняется уже на других за тот же самый период.

Это объясняет большую часть случаев "мне пришло уведомление за такое-то время, на графике Alert evaluation status столбик красный, но когда я туда кликаю, результат вычисления — OK."

{% endnote %}

#### График
На самом графике Alert chart отображаются ряды для всех переменных, содержащие временные ряды на момент окончания выполнения программы. После возврата программы по условию из `alarm_if` и подобных функций не выполняются и не отображаются на графике.

Пример 1:
```
let a = {project="myproject", cluster="production", "service"="myapp", name="mymetric"};
let b = {project="myproject", cluster="production", "service"="myapp", name="myanothermetric"};

alarm_if(avg(a+b) < 5);
```

На графике будут отображены ряды a и b.

Пример 2:
```
let a = {project="myproject", cluster="production", "service"="myapp", name="mymetric"};

warn_if(avg(a+b) < 5);

let b = {project="myproject", cluster="production", "service"="myapp", name="myanothermetric"};
```

На графике будет отображен ряд a, если статус алерта будет рассчитан как `WARN`, и ряды a и b, если статус не `WARN`.

Исключить переменные, используемые в промежуточных расчётах, можно присвоением им значения `0`:
```
let a_lot_of_rows = {project="myproject", cluster="production", "service"="myapp", name="mymetric"};
let sum_rows = series_sum(a_lot_of_rows);

let a_lot_of_rows = 0;

warn_if(avg(sum_rows) > 80);
```

В этом примере на графике будет отображен только ряд sum_rows.

На графике отображаются только временные ряды. Вывести значение скаляров можно при помощи аннотаций.

```
let a = {project="myproject", cluster="production", "service"="myapp", name="errors_count"};
let b = {project="myproject", cluster="production", "service"="myapp", name="queries_count"};
let limit = {project="myproject", cluster="production", "service"="myapp", name="limit"}

let ratio = avg(a / b * 100);
let limit = avg(limit);

alarm_if(ratio > limit);
```

Аннотации:

Ключ | Значение
-----|---------
ratio | `not_var{{expression.ratio}}`
limit | `not_var{{expression.limit}}`

{% note tip %}

При создании нового алерта или редактировании существующего можно использовать кнопку Explain — она выполняет такой же расчёт, что и график Alert chart, с программой и параметрами из текущей формы, на текущих данных.

{% endnote %}

В будущих версиях Solomon инструменты для отладки алертов будут расширяться и упрощаться.

<!--
### Как понять причину ложного срабатывания или несрабатывания алерта?

Отладке подобных ситуаций посвящена отдельная [пошаговая инструкция](operations/alerting/false.md).

### Почему алерт не сработал, хотя на графике "Alert chart" в алерта явно видно, что он должен был сработать?

Скорее всего, причина в том, что график "Alert chart" рассчитывается чаще, чем сам алерт. Подробности приведены в пошаговой инструкции ["Отладка ложных срабатываний/несрабатываний алерта"](operations/alerting/false.md).

### Как понять, почему алерт сработал не сразу?

Отладке подобных ситуаций посвящена отдельная [пошаговая инструкция](operations/alerting/slow.md).
-->

## Конфигурирование

### Как получить доступ к проекту?

Доступ к проекту выдается администраторами этого проекта. Более подробную информацию смотрите в разделе [Управление доступом](security/index.md).

### Как сменить владельца проекта или удалить проект?
Поменять владельца или удалить проект может только текущий владелец проекта, обратитесь к нему.
Если это невозможно, то создайте тикет в очереди [MONSUPPORT](https://st.yandex-team.ru/createTicket?queue=monsupport).

### Почему не получается добавить телеграм-бота в группу?
Для добавления бота в группу должно выполняться несколько условий:

1. Бот должен быть добавлен в уже существующий чат;
2. Бота можно добавить только в группу, но нельзя добавить в канал;
3. Телеграммный аккаунт человека, добавляющего бота, должен быть указан на стаффе и отмечен как рабочий.

Также нужно иметь в виду, что при апгрейде группы на супергруппу, у группы меняется id и бот перестает работать. В этом случае нужно удалить его из группы и добавить заново.

Более подробную информацию про работу с Telegram можно получить в [документации](concepts/alerting/index.md#telegram).

<!--
TODO фак:
- базовый вопрос "как мне пользоваться Мониторингом"
  — настрой сбор метрик (каких? дать рекомендации, золотые сигналы, как называть, рассказать про либы с метриками)
  - отладь их через UI
  - построй дашборды
  - настрой алерты
- почему разное количество метрик в шардах? "Но обычно это метрики, которые уже протухли и просто не успели почиститься во втором кластере из-за разного времени запуска TTL задач"
-->
