# Что такое Solomon

**Solomon** (Yandex Monitoring) — распределенная и высокодоступная система количественного мониторинга. Solomon используется для сбора, агрегации, хранения и визуализации метрик (временных рядов). Кроме этого, Solomon может оповещать об изменениях в собираемых метриках через различные каналы связи: Email, SMS, Телефонный звонок, Telegram, Yandex.Messenger, Webhook и Juggler.

## Ключевые особенности {#features}

Ключевыми особенностями Solomon являются:
* гибкая многомерная [модель данных](../concepts/data-model.md) для временных рядов;
* push- и pull-режимы сбора метрик с множеством способов service discovery;
* [язык запросов](../concepts/querying.md) для агрегации, преобразования и вычисления произвольных выражений над временными рядами;
* возможность [предварительной агрегации](../concepts/aggregation.md) метрик на стороне Solomon перед записью в хранилище;
* реплицированное долговременное хранилище метрик без ограничения на длительность хранения истории;
* веб-интерфейс для визуализации метрик в виде графиков и дашбордов;
* продвинутая система [алертинга](../concepts/alerting/index.md) об изменениях в собираемых метриках;
* широкий спектр поддерживаемых [методов уведомлений](../concepts/alerting/index.md#channel-methods): Email, SMS, Телефонный звонок, Telegram, Yandex.Messenger, Webhook и Juggler;
* соответствие принципу [мультиарендности](https://ru.wikipedia.org/wiki/Мультиарендность) (multitenancy), что обеспечивает изоляцию между различными проектами;
* работа по модели [SaaS](https://ru.wikipedia.org/wiki/Программное_обеспечение_как_услуга).

## Для чего подходит Solomon? {#when-does-it-fit}

Система Solomon в первую очередь предназначена для периодической записи метрик — текущего состояния пользовательских приложений — и для наблюдения за этими данными как при помощи средств визуализации (дашбордов), так и при помощи уведомлений от сервиса алертинга.

## Для чего не подходит Solomon? {#when-does-it-not-fit}

Solomon не подходит для решения следующих задач:
- сбора данных, для которых критична полнота и целостность, например, данные биллинга;
- сбора и хранения логов;
- сбора и хранения одиночных событий и богатой мета-информации о них (тексты исключений ошибок, и т.п.)
- визуализации произвольных данных, непривязанных ко времени;
- вычисления произвольных OLAP-запросов.

<!-- В силу высоких требований к отказоустойчивости и скорости работы Solomon может жертвовать консистентностью записываемых данных, так для быстрого получения информации о состоянии пользовательского приложения (особенно в момент аварии или инцидента, когда данные, хранящиеся в мониторинге наиболее интересны) намного важнее получить хотя бы частичный ответ, нежели на 100% консистентный. Из этого следует, что Solomon не будет хорошим выбором для хранения данных, требующих максимально высокой точности, или метрик, для которой неприемлема потеря нескольких точек.

Solomon (пока) не является системой сбора и обработки логов, поэтому Solomon не подойдет для записи в него логов приложений для дальнейшего поиска и агрегации. Также Solomon не подходит для записи в него одиночных событий и хранения больших объемов метаинформации, например, произвольных текстов ошибок и другой диагностической информации изменяющейся от события к событию.

Solomon, в отличие от [DataLens](https://datalens.yandex-team.ru), не является системой визуализации произвольных данных: в основе [модели данных](../concepts/data-model.md) Solomon лежит понятие временного ряда, поэтому все визуализируемые данные так или иначе привязаны ко времени.

Несмотря на свою многомерную модель данных и наличие [языка запросов](../concepts/querying.md), позволяющего выполнять практически произвольные вычисления над временным рядами, Solomon не является полноценной [OLAP](https://ru.wikipedia.org/wiki/OLAP)-системой ввиду отсутствия операций объединения (join) и поддержки словарей данных. -->
