import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.inside.solomon.pusher.SolomonPusher;
import ru.yandex.misc.asyncHttpClient2.AsyncHttpClientUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.monica.solomon.sensors.PushSensorsData;
import ru.yandex.misc.monica.solomon.sensors.Sensor;


public class Main {

    private static final String PROJECT = "examples";
    private static final String CLUSTER = "test";
    private static final String SERVICE = "json_push";
    private static final String FILE_NAME = "prev.txt";

    public static void main(String[] args) {
        String oauthToken = System.getenv("OAUTH_TOKEN");
        if (StringUtils.isEmpty(oauthToken)) {
            System.err.println("Please put valid oauth token into OAUTH_TOKEN environment variable");
            System.exit(1);
        }

        var solomonPusher = SolomonPusher.ownHttpClient(AsyncHttpClientUtils.newAsyncHttpClient("Solomon-Pusher"))
            .oauthToken(oauthToken)
            .debugNon200()
            .build();

        try (solomonPusher) {
            Map<String, String> commonLabels = new HashMap<>();
            commonLabels.put("host", "my-test-host");

            Map<String, String> labels = new HashMap<>();
            labels.put("sensor", "sinusoid");

            long index = getPrevValue();
            writeToFile(index + 1);
            double y = Math.sin(Math.toRadians(index));
            Sensor sensor = new Sensor(labels, y);

            var data = new PushSensorsData(PROJECT, CLUSTER, SERVICE, commonLabels, Collections.singletonList(sensor));
            solomonPusher.push(data).join();

            System.out.println(Instant.now() + " successful push");
        } catch (Throwable t) {
            System.out.println(Instant.now() + " exception:" + t);
            System.exit(1);
        }
    }

    private static long getPrevValue() {
        try {
            List<String> strings = Files.readAllLines(Paths.get(FILE_NAME));
            return Long.parseLong(strings.get(0));
        } catch (IOException e) {
            return 0;
        }
    }

    private static void writeToFile(long newValue) throws IOException {
        String value = Long.toString(newValue);
        Files.write(Paths.get(FILE_NAME), Collections.singletonList(value));
    }
}
