import { doubleQuote } from './Quoter';

export function isGlobValue(value) {
  return value.indexOf('*') >= 0 || value.indexOf('|') >= 0 || value.indexOf('?') >= 0;
}

class Selector {
  static any(key) {
    return new Selector('=', key, '*');
  }

  static absent(key) {
    return new Selector('=', key, '-');
  }

  static exact(key, value) {
    return new Selector('==', key, value);
  }

  static notExact(key, value) {
    return new Selector('!==', key, value);
  }

  static glob(key, value) {
    return new Selector('=', key, value);
  }

  static notGlob(key, value) {
    return new Selector('!=', key, value);
  }

  static regex(key, value) {
    return new Selector('=~', key, value);
  }

  static notRegex(key, value) {
    return new Selector('!~', key, value);
  }

  constructor(op, key, value) {
    this._op = op;
    this._key = key;
    this._value = value;
  }

  getKey() {
    return this._key;
  }

  getOp() {
    return this._op;
  }

  getValue() {
    return this._value;
  }

  isExact() {
    return this._op === '=='
      || ((this._op === '=' && !isGlobValue(this._value)));
  }

  format() {
    const quotedKey = this._key.indexOf('-') >= 0 ? doubleQuote(this._key) : this._key;
    const quotedValue = doubleQuote(this._value);
    return `${quotedKey}${this._op}${quotedValue}`;
  }
}

export default Selector;
