class Node {
    constructor() {
        this.isWord = false;
        this.children = {};
    }
}

export class Trie {
    constructor() {
        this.root = new Node();
    }

    add(word) {
        if (!this.root) {
            return;
        }
        this._addNode(this.root, word);
    }

    _addNode(node, word) {
        if (!node || !word) {
            return;
        }
        const letter = word.charAt(0);
        let child = node.children[letter];
        if (!child) {
            child = new Node();
            node.children[letter] = child;
        }
        const remainder = word.substring(1);
        if (!remainder) {
            child.isWord = true;
        }
        this._addNode(child, remainder);
    }

    getWords() {
        let words = [];
        this._getWords(this.root, words, '');
        return words;
    }

    _getWords(node, words, word) {
        if (Object.keys(node.children).length > 1 || word.length === 0) {
            words.push(word + "*");
        }

        for (let child in node.children) {
            if (node.children.hasOwnProperty(child)) {
                word += child;
                if (node.children[child].isWord) {
                    words.push(word);
                }
                this._getWords(node.children[child], words, word);
                word = word.substring(0, word.length - 1);
            }
        }
    }
}
