package ru.yandex.market.graphouse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.solomon.util.http.HttpUtils;

/**
 * @author Vladimir Gordiychuk
 */
public class ApiExceptionHandler implements WebExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ApiExceptionHandler.class);

    @Override
    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        ServerHttpRequest request = exchange.getRequest();
        Throwable cause = CompletableFutures.unwrapCompletionException(ex);
        logger.error(format(request) + " API internal server exception #", cause);
        return Mono.error(ex);
    }

    private static String format(ServerHttpRequest request) {
        String remoteAddr = HttpUtils.realOrRemoteIp(request);
        return remoteAddr + ' ' + request.getMethod() + ' ' + HttpUtils.requestUri(request);
    }
}
