package ru.yandex.market.graphouse;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.discovery.conductor.ConductorResolveService;
import ru.yandex.market.graphouse.monitoring.BalancerController;
import ru.yandex.market.graphouse.monitoring.MegaGraphiteStaffOnlyController;
import ru.yandex.market.graphouse.monitoring.SolomonMonitoringContext;
import ru.yandex.market.graphouse.monitoring.VersionController;
import ru.yandex.market.graphouse.retention.WhitelistRetention;
import ru.yandex.market.graphouse.search.MetricDataController;
import ru.yandex.market.graphouse.search.MetricEngineContext;
import ru.yandex.market.graphouse.search.MetricSearchController;
import ru.yandex.market.graphouse.search.dao.DaoContext;
import ru.yandex.monlib.metrics.webflux.filters.HttpStatsFilter;
import ru.yandex.solomon.auth.Account;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.Authenticator;
import ru.yandex.solomon.auth.Authorizer;
import ru.yandex.solomon.auth.http.HttpAuthenticator;
import ru.yandex.solomon.auth.internal.InternalAuthorizer;
import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.http.filters.RequestLoggingFilter;
import ru.yandex.solomon.selfmon.GeneralMonitoringContext;
import ru.yandex.solomon.selfmon.mon.SelfMetricsController;

/**
 * @author Maksim Leonov (nohttp@)
 */
@Configuration
@Import({
        MetricEngineContext.class,
        MetricSearchController.class,
        MetricDataController.class,
        SelfMetricsController.class,
        BalancerController.class,
        VersionController.class,
        MegaGraphiteStaffOnlyController.class,
        RequestLoggingFilter.class,
        HttpStatsFilter.class,
        ApiExceptionHandler.class,
        SolomonMonitoringContext.class,
        LazyThreadPoolProvider.class,
        GeneralMonitoringContext.class,
        LazyThreadPoolProvider.class,
        DaoContext.class,
        MegaGraphiteWebContext.class,
})
public class MegaGraphiteContext {

    @Bean
    public Authorizer fakeAuthorizer() {
        return Authorizer.anonymous();
    }

    @Bean
    public InternalAuthorizer internalAuthorizer() {
        return new InternalAuthorizer(Set.of()) {
            @Override
            public CompletableFuture<Account> authorize(AuthSubject subject) {
                return CompletableFuture.completedFuture(Account.ANONYMOUS);
            }
        };
    }

    @Bean
    public HttpAuthenticator httpAuthenticator() {
        return new HttpAuthenticator(Authenticator.anonymous());
    }

    @Bean
    public WhitelistRetention whitelistRetention() {
        return new WhitelistRetention("whitelistRetention.txt");
    }

    @Bean
    public ConductorResolveService conductorResolveService(ThreadPoolProvider threads) {
        return new ConductorResolveService(threads.getExecutorService("CpuLowPriority", ""));
    }
}
