package ru.yandex.market.graphouse.cacher;

import java.util.concurrent.CopyOnWriteArrayList;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.market.graphouse.stockpile.GraphouseStockpileClient;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"/>
 * @date 06/04/15
 */
@Component
public class MetricCacherProvider {

    private final GraphouseStockpileClient client;

    private CopyOnWriteArrayList<MetricCacher> writers = new CopyOnWriteArrayList<>();

    @Autowired
    public MetricCacherProvider(GraphouseStockpileClient client) {
        this.client = client;
    }

    public MetricCacher makeCacher(String id) {
        MetricCacher writer = new MetricCacher(id, client);
        writers.add(writer);
        return writer;
    }

    public void shutdown() {
        for (MetricCacher writer : writers) {
            writer.shutdownHook();
        }
    }
}
