package ru.yandex.market.graphouse.monitoring;

import java.io.IOException;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.library.svnversion.VcsVersion;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
@Controller
public class VersionController {
    private static final VcsVersion VCS = new VcsVersion(VersionController.class);
    @RequestMapping(value = "/version/raw", produces = "text/plain")
    @ResponseBody
    public String version() throws IOException {
        return String.format(
            "project.svn.rev: %d\n" +
                "project.svn.url: %s\n" +
                "build.date: %s\n" +
                "build.host: %s\n" +
                "build.user: %s\n",
            VCS.getProgramSvnRevision(),
            VCS.getArcadiaSourceUrl(),
            VCS.getProgramBuildDate(),
            VCS.getProgramBuildHost(),
            VCS.getProgramBuildUser());
    }
}
