package ru.yandex.market.graphouse.retention;

import javax.annotation.Nonnull;

import ru.yandex.market.graphouse.search.MetricDescription;

/**
 * @author Maksim Leonov (nohttp@)
 */
public interface RetentionManager {

    byte getRetentionIdForMetric(String metricName);

    @Nonnull
    Retention getRetentionById(short id);

    default short getStockpilePolicyId(MetricDescription md) {
        return getRetentionById(md.getRetentionId()).getPolicyId();
    }
}
