package ru.yandex.market.graphouse.retention;

import org.springframework.stereotype.Component;

import ru.yandex.market.graphouse.PatternListFile;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.staffOnly.annotations.LinkedOnRootPage;
import ru.yandex.solomon.staffOnly.annotations.ManagerMethod;

/**
 * @author alexlovkov
 */
@Component
@LinkedOnRootPage("Retention White List")
public class WhitelistRetention {

    private final PatternListFile whitelist;
    private final Rate matchRate;

    public WhitelistRetention(String fileName) {
        this.whitelist = new PatternListFile(fileName);
        MetricRegistry metricRegistry = MetricRegistry.root();
        this.matchRate = metricRegistry.rate("whitelist.match");
    }

    @ManagerMethod
    public void addPattern(String pattern) {
        whitelist.addPattern(pattern);
    }

    @ManagerMethod
    public void removePattern(String pattern) {
        whitelist.removePattern(pattern);
    }

    @ManagerMethod
    public void updatePattern(String oldPattern, String newPattern) {
        whitelist.updatePattern(oldPattern, newPattern);
    }

    public boolean match(String metric) {
        boolean match = whitelist.isMatch(metric, null);
        if (match) {
            matchRate.inc();
        }
        return match;
    }

    /**
     * for test purpose only
     */
    void clearFile() {
        whitelist.clearFile();
    }
}
