package ru.yandex.market.graphouse.search;

import java.util.EnumMap;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public class MetricAddException extends Exception {
    private static final EnumMap<MetricResponseStatus, MetricAddException> cachedExceptions;

    static {
        cachedExceptions = new EnumMap<>(MetricResponseStatus.class);
        for (MetricResponseStatus status : MetricResponseStatus.values()) {
            cachedExceptions.put(status, new MetricAddException(status));
        }
    }

    public final MetricResponseStatus status;

    private MetricAddException(MetricResponseStatus status) {
        this.status = status;
    }

    public static MetricAddException problem(MetricResponseStatus status) {
        return cachedExceptions.get(status);
    }
}
