package ru.yandex.market.graphouse.search;

import ru.yandex.market.graphouse.search.tree.MetricBase;
import ru.yandex.market.graphouse.search.tree.MetricBaseZip;
import ru.yandex.stockpile.client.shard.StockpileMetricId;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"/>
 * @date 02/09/15
 */
public interface MetricDescription {

    String getName();

    MetricTreeStatus getStatus();

    boolean isDir();

    long getUpdateTimeMillis();

    StockpileMetricId getStockpileId();

    short getRetentionId();

    /**
     * @return last timestamp (in seconds) of writing to this metric, 0 otherwise
     */
    int getLastWriteTimestamp();

    /**
     * update last timestamp for current metric
     * @param timestamp updating time in seconds
     */
    void updateLastWriteTimestamp(int timestamp);

    MetricBaseZip<? extends MetricBase> asZip();
}
