package ru.yandex.market.graphouse.search;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.market.graphouse.PatternListFile;
import ru.yandex.market.graphouse.cacher.MetricCacherProvider;
import ru.yandex.market.graphouse.retention.HardcodedRetentionManager;
import ru.yandex.market.graphouse.server.MetricFactory;
import ru.yandex.market.graphouse.server.MetricLimbo;
import ru.yandex.market.graphouse.server.MetricServer;
import ru.yandex.market.graphouse.server.MetricValidator;
import ru.yandex.market.graphouse.stockpile.GraphouseStockpileContext;

/**
 * @author Maksim Leonov (nohttp@)
 */
@Configuration
@Import({
    GraphouseStockpileContext.class,
    HardcodedRetentionManager.class,
    MetricValidator.class,
    MetricServer.class,
    MetricSearch.class,
    MetricCacherProvider.class,
    MetricFactory.class,
    MetricLimbo.class,
})
public class MetricEngineContext {

    @Bean(name = "ttlBlacklist")
    public PatternListFile PatternListFile() {
        return new PatternListFile("ttlMetrics.txt");
    }

}
