package ru.yandex.market.graphouse.search;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"/>
 * @date 08/04/15
 */
@Controller
public class MetricSearchController {

    @Autowired
    private MetricSearch metricSearch;

    @RequestMapping("/search")
    public ResponseEntity<byte[]> search(
        @RequestParam(name = "query") String query,
        @RequestParam(name = "user", defaultValue = "unknown") String userName) throws IOException
    {
        MetricRegistry.root().rate("rps.read.search", Labels.of("user", userName)).inc();
        var out = new ByteArrayOutputStream();
        try (var writer = new PrintWriter(out)) {
            metricSearch.search(query, writer);
        }
        return ResponseEntity.ok(out.toByteArray());
    }
}
