package ru.yandex.market.graphouse.search.dao;

import java.util.Iterator;
import java.util.NoSuchElementException;

import javax.annotation.Nonnull;

import ru.yandex.market.graphouse.search.MetricDbRow;
import ru.yandex.market.graphouse.search.MetricTreeStatus;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricArray implements Iterable<MetricDbRow> {
    private final String[] name;
    private final MetricTreeStatus[] status;
    private final int[] shardId;
    private final long[] localId;

    private int size;

    public MetricArray(int capacity) {
        this.name = new String[capacity];
        this.status = new MetricTreeStatus[capacity];
        this.shardId = new int[capacity];
        this.localId = new long[capacity];
        this.size = 0;
    }

    public int size() {
        return size;
    }

    @Override
    @Nonnull
    public Iterator<MetricDbRow> iterator() {
        return new Itr();
    }

    public void add(String name, MetricTreeStatus status, int shardId, long localId) {
        int idx = size++;
        this.name[idx] = name;
        this.status[idx] = status;
        this.shardId[idx] = shardId;
        this.localId[idx] = localId;
    }

    public MetricDbRow get(int index) {
        return new MetricDbRow(name[index], status[index], shardId[index], localId[index]);
    }

    public String getName(int index) {
        return name[index];
    }

    public MetricTreeStatus getStatus(int index) {
        return status[index];
    }

    public int getShardId(int index) {
        return shardId[index];
    }

    public long getLocalId(int index) {
        return localId[index];
    }

    private class Itr implements Iterator<MetricDbRow> {
        int cursor;

        public boolean hasNext() {
            return cursor != size;
        }

        public MetricDbRow next() {
            if (cursor >= size)
                throw new NoSuchElementException();
            return get(cursor++);
        }
    }
}
