package ru.yandex.market.graphouse.search.dao;

import java.time.Instant;

import ru.yandex.market.graphouse.search.MetricDbRow;
import ru.yandex.market.graphouse.search.MetricTreeStatus;

/**
 * @author alexlovkov
 */
public record MetricRow(String name, int status, int updateDateSeconds, int shardId, long localId) {
    public static MetricRow of(String name, int status, Instant updateDate, int shardId, long localId) {
        return new MetricRow(name, status, Math.toIntExact(updateDate.getEpochSecond()), shardId, localId);
    }

    public MetricDbRow mapToMetricDbRow() {
        return new MetricDbRow(name, MetricTreeStatus.forId(status), shardId, localId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MetricRow)) return false;

        MetricRow metricRow = (MetricRow) o;

        return name.equals(metricRow.name);
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }
}
