package ru.yandex.market.graphouse.search.dao;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import ru.yandex.solomon.staffOnly.annotations.LinkedOnRootPage;

/**
 * @author alexlovkov
 */
@LinkedOnRootPage("Metrics DAO")
public interface MetricsDao {

    CompletableFuture<Void> saveMetrics(List<MetricRow> metrics);

    CompletableFuture<Integer> loadAllMetrics(Consumer<MetricArray> consumer);

    CompletableFuture<Integer> loadNewMetrics(
        Consumer<MetricArray> consumer,
        int startTimestampSeconds);

    CompletableFuture<Void> remove(List<String> metrics);

    CompletableFuture<Void> removeOldRows();
}
