package ru.yandex.market.graphouse.search.dao;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.primitives.Counter;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricsDaoMetrics {
    public final Counter deleteRowsCounter;
    public final Counter failDeletionCounter;
    public final Counter successDeletionCounter;
    public final Histogram histogramDeletionTime;
    public final Rate readMetrics;
    public final Rate readFreshMetrics;
    public final Rate addMetrics;
    public final Rate deleteFreshMetrics;

    public MetricsDaoMetrics() {
        MetricRegistry metricRegistry = MetricRegistry.root();
        this.deleteRowsCounter = metricRegistry.counter("metricsDao.deleteRows");
        this.failDeletionCounter = metricRegistry.counter("metricsDao.failedDeletion");
        this.successDeletionCounter = metricRegistry.counter("metricsDao.successDeletion");
        this.histogramDeletionTime = metricRegistry
                .histogramRate("metricsDao.deletionTime", Histograms.exponential(13, 2, 16));
        this.readMetrics = metricRegistry.rate("metricsDao.readMetrics");
        this.readFreshMetrics = metricRegistry.rate("metricsDao.readFreshMetrics");
        this.addMetrics = metricRegistry.rate("metricsDao.addMetrics");
        this.deleteFreshMetrics = metricRegistry.rate("metricsDao.deleteFreshMetrics");
    }
}
