package ru.yandex.market.graphouse.search.dao.ydb;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author Vladimir Gordiychuk
 */
public class LoadCompletableFuture extends CompletableFuture<Integer> {
    private final AtomicInteger opInflight = new AtomicInteger(1);
    private volatile int readMetrics;

    void finishOperation(int value) {
        readMetrics = value;
        finishOperation();
    }

    void addOperation() {
        opInflight.incrementAndGet();
    }

    void finishOperation() {
        if (opInflight.decrementAndGet() == 0) {
            complete(readMetrics);
        }
    }
}
