package ru.yandex.market.graphouse.search.dao.ydb;

import java.nio.file.Path;

/**
 * @author Vladimir Gordiychuk
 */
class YdbQueries {
    final String metricsTable;
    final String metricsLastUpdatesTable;

    final String saveQuery;
    final String selectNewQuery;
    final String deleteQuery;
    final String ttlSelectQuery;
    final String ttlDeleteQuery;

    public YdbQueries(String root) {
        var path = Path.of(root);
        this.metricsTable = path.resolve(YdbMetricsTable.TABLE_NAME).toString();
        this.metricsLastUpdatesTable = path.resolve(YdbLastUpdateTable.TABLE_NAME).toString();

        this.saveQuery = String.format("""
                --!syntax_v1
                DECLARE $rows AS %s;

                $update = (
                    SELECT new.*
                    FROM AS_TABLE($rows) as new LEFT JOIN `%s` as old USING (hash, name)
                    WHERE old.hash IS NULL
                );

                REPLACE INTO `%s` SELECT * FROM $update;
                REPLACE INTO `%s` SELECT updateDateSeconds, name, status, shardId, localId FROM $update;
                """, YdbMetricsTable.METRIC_LIST_TYPE, metricsTable, metricsTable, metricsLastUpdatesTable);

        this.selectNewQuery = String.format("""
                --!syntax_v1
                DECLARE $startInc AS Uint32;
                SELECT * FROM `%s` WHERE updateDateSeconds >= $startInc
                LIMIT 1000;
                """, metricsLastUpdatesTable);

        this.deleteQuery = String.format("""
                --!syntax_v1
                DECLARE $keys AS %s;
                DELETE FROM `%s` ON SELECT * FROM AS_TABLE($keys);
                """, YdbMetricsTable.METRIC_PK_LIST_TYPE, metricsTable);

        this.ttlSelectQuery = String.format("""
                --!syntax_v1
                DECLARE $deletionTime AS Uint32;
                SELECT updateDateSeconds, name FROM `%s` WHERE updateDateSeconds < $deletionTime
                LIMIT 1000;
                """, metricsLastUpdatesTable);

        this.ttlDeleteQuery = String.format("""
                --!syntax_v1
                DECLARE $keys AS %s;
                DELETE FROM `%s` ON SELECT * FROM AS_TABLE($keys);
                """, YdbLastUpdateTable.METRIC_PK_LIST_TYPE, metricsLastUpdatesTable);
    }
}
