package ru.yandex.market.graphouse.search.tree;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.market.graphouse.retention.RetentionManager;
import ru.yandex.market.graphouse.search.MetricDescription;
import ru.yandex.market.graphouse.search.MetricTree;
import ru.yandex.market.graphouse.stockpile.GraphouseStockpileIdGenerator;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class DirZip extends MetricBaseZip<Dir> {

    public DirZip(Dir root) {
        super(root);
    }

    public DirZip(DirZip parent, Dir self) {
        super(parent, self);
    }

    public static DirZip of(List<Dir> dirs) {
        DirZip parent = new DirZip(dirs.get(0));
        for (int index = 1; index < dirs.size(); index++) {
            parent = parent.wrapChildDir(dirs.get(index));
        }
        return parent;
    }

    @Nullable
    public DirZip getDir(String name) {
        return Nullables.map(self.getDir(name), this::wrapChildDir);
    }

    @Nonnull
    public DirZip getOrCreateDir(MetricTree metricTree, String level) {
        return wrapChildDir(self.getOrCreateDir(metricTree, level));
    }

    @Nullable
    public MetricNameZip getMetric(String name) {
        return Nullables.map(self.getMetric(name), this::wrapChildMetric);
    }

    @Nonnull
    public MetricNameZip getOrCreateMetric(MetricTree metricTree, String name, String fullName, GraphouseStockpileIdGenerator idSource, RetentionManager retentionManager) {
        return wrapChildMetric(self.getOrCreateMetric(metricTree, name, fullName, idSource, retentionManager));
    }

    @Nonnull
    private DirZip wrapChildDir(Dir c) {
        return new DirZip(this, c);
    }

    @Nonnull
    private MetricNameZip wrapChildMetric(MetricName c) {
        return new MetricNameZip(this, c);
    }

    @Override
    public boolean isRoot() {
        return parent == null;
    }

    @Nonnull
    public Iterable<DirZip> listDirs() {
        Iterable<Dir> dirs = self.listDirs();
        return new Iterable<DirZip>() {
            @Override
            public Iterator<DirZip> iterator() {
                return Cf.x(dirs.iterator()).map(c -> wrapChildDir(c));
            }
        };
    }

    @Nonnull
    public Iterable<MetricNameZip> listMetrics() {
        Iterable<MetricName> metricNames = self.listMetrics();
        return new Iterable<MetricNameZip>() {
            @Override
            public Iterator<MetricNameZip> iterator() {
                return Cf.x(metricNames.iterator()).map(c -> wrapChildMetric(c));
            }
        };
    }

    public Stream<MetricDescription> allMetrics() {
        Stream<MetricDescription> subDirs = StreamSupport.stream(listDirs().spliterator(), false).flatMap(DirZip::allMetrics);
        Stream<? extends MetricDescription> own = StreamSupport.stream(listMetrics().spliterator(), false);
        return Stream.concat(subDirs, own);
    }

}
