package ru.yandex.market.graphouse.search.tree;

import java.util.concurrent.locks.ReentrantLock;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.market.graphouse.search.MetricTreeStatus;
import ru.yandex.misc.lang.IntegerUtils;

@ParametersAreNonnullByDefault
public abstract class MetricBase {
    protected final String name;

    private static final long UPDATE_TIME_MASK = (1L << 61) - 1;

    private volatile long updateTimeMillisAndStatus = System.currentTimeMillis();

    MetricBase(String name) {
        this.name = name;
    }

    public boolean visible() {
        return getStatus().visible();
    }

    public String getLastNameChunk() {
        return name;
    }

    public MetricTreeStatus getStatus() {
        long statusBits = updateTimeMillisAndStatus >>> 61;
        return MetricTreeStatus.values[(int) statusBits];
    }

    public void setStatus(MetricTreeStatus status) {
        if (this.getStatus() != status) {
            long statusBits = (long) status.ordinal() << 61;
            updateTimeMillisAndStatus = System.currentTimeMillis() | statusBits;
        }
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "{" +
            "name='" + name + '\'' +
            ", updateTime=" + getUpdateTimeMillis() +
            ", status=" + getStatus() +
            '}';
    }

    public long getUpdateTimeMillis() {
        return updateTimeMillisAndStatus & UPDATE_TIME_MASK;
    }

    private static final ReentrantLock[] locks = new ReentrantLock[256];

    static {
        if (!IntegerUtils.isPowerOf2(locks.length)) {
            throw new RuntimeException();
        }
        for (int i = 0; i < locks.length; i++) {
            locks[i] = new ReentrantLock();
        }
    }

    ReentrantLock getLock() {
        return locks[getLastNameChunk().hashCode() & (locks.length - 1)];
    }
}
