package ru.yandex.market.graphouse.search.tree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.market.graphouse.search.MetricDescription;
import ru.yandex.market.graphouse.search.MetricTreeStatus;
import ru.yandex.stockpile.client.shard.StockpileMetricId;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class MetricBaseZip<D extends MetricBase> implements MetricDescription {

    @Nullable
    public final DirZip parent;
    @Nonnull
    public final D self;

    public MetricBaseZip(D root) {
        this.parent = null;
        this.self = root;

        if (!(root instanceof Dir)) {
            throw new IllegalArgumentException();
        }
    }

    public MetricBaseZip(DirZip parent, D self) {
        this.parent = parent;
        this.self = self;
    }

    @Nullable
    public DirZip getParent() {
        return parent;
    }

    public boolean isRoot() {
        return parent == null;
    }

    @Override
    public String getName() {
        if (isRoot()) {
            return "ROOT";
        }
        StringBuilder sb = new StringBuilder();
        buildNameTo(sb);
        return sb.toString();
    }

    protected void buildNameTo(StringBuilder sb) {
        if (!parent.isRoot()) {
            parent.buildNameTo(sb);
            sb.append(".");
        }
        sb.append(self.name);
    }

    @Override
    public MetricTreeStatus getStatus() {
        return self.getStatus();
    }

    @Override
    public boolean isDir() {
        return this instanceof DirZip;
    }

    @Override
    public long getUpdateTimeMillis() {
        return self.getUpdateTimeMillis();
    }

    @Override
    public StockpileMetricId getStockpileId() {
        return ((MetricName) self).getStockpileId();
    }

    @Override
    public short getRetentionId() {
        return ((MetricName) self).getRetentionId();
    }

    @Override
    public int getLastWriteTimestamp() {
        return 0;
    }

    @Override
    public void updateLastWriteTimestamp(int timestamp) {
    }

    @Override
    public MetricBaseZip<?> asZip() {
        return this;
    }

    @Override
    public String toString() {
        return "MetricBaseZip{" +
            "path=" + getName() +
            ", self=" + self +
            '}';
    }
}
