package ru.yandex.market.graphouse.search.tree;

import java.util.concurrent.locks.ReentrantLock;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.stockpile.client.shard.StockpileMetricId;

@ParametersAreNonnullByDefault
public class MetricName extends MetricBase {

    private short stockpileShardId;
    private long stockpileLocalId;
    private volatile boolean isFromDb;

    private final byte retentionId;
    private volatile int lastWriteTimestampSeconds;

    public MetricName(String name, StockpileMetricId id, boolean isFromDb, byte retentionId) {
        super(name);
        this.stockpileShardId = (short) id.getShardId();
        this.stockpileLocalId = id.getLocalId();
        this.isFromDb = isFromDb;
        this.retentionId = retentionId;
        this.lastWriteTimestampSeconds = 0;
    }

    public StockpileMetricId getStockpileId() {
        ReentrantLock lock = getLock();
        lock.lock();
        try {
            return new StockpileMetricId(this.stockpileShardId, this.stockpileLocalId);
        } finally {
            lock.unlock();
        }
    }

    public short getRetentionId() {
        return retentionId;
    }

    void setStockpileIdFromDb(StockpileMetricId stockpileMetricId) {
        ReentrantLock lock = getLock();
        lock.lock();
        try {
            this.stockpileShardId = (short) stockpileMetricId.getShardId();
            this.stockpileLocalId = stockpileMetricId.getLocalId();
            this.isFromDb = true;
        } finally {
            lock.unlock();
        }
    }

    public boolean isFromDb() {
        return isFromDb;
    }

    public int getLastWriteTimestampSeconds() {
        return lastWriteTimestampSeconds;
    }

    public void setLastWriteTimestampSeconds(int lastWriteTimestampSeconds) {
        this.lastWriteTimestampSeconds = lastWriteTimestampSeconds;
    }
}
