package ru.yandex.market.graphouse.search.tree;

import java.io.PrintWriter;
import java.util.Comparator;

import javax.annotation.ParametersAreNonnullByDefault;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public class TreeStats {
    public Int2IntArrayMap dirCountBySubdirCount = new Int2IntArrayMap();
    public Int2IntArrayMap dirCountByMetricCount = new Int2IntArrayMap();
    int onlyMetrics = 0;
    int onlyDirs = 0;
    int both = 0;
    int none = 0;

    public void print(PrintWriter out) {
        out.println("both: " + both);
        out.println("onlyMetrics: " + onlyMetrics);
        out.println("onlyDirs: " + onlyDirs);
        out.println("none: " + none);

        out.println();

        out.println("Dircounts:");
        printmap(dirCountBySubdirCount, out);

        out.println();

        out.println("Metriccounts:");
        printmap(dirCountByMetricCount, out);
    }

    private static void printmap(Int2IntMap map, PrintWriter out) {
        map.int2IntEntrySet().stream().sorted(Comparator.comparingInt(Int2IntMap.Entry::getIntValue)).forEach(x -> {
            out.println(x.getIntKey() + " => " + x.getIntValue());
        });
    }
}
