package ru.yandex.market.graphouse.search.util;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Maksim Leonov (nohttp@)
 *
 * Memory-effective collection with a map-like interface, which allows adding and retrieving non-null elements concurrently.
 */
@ParametersAreNonnullByDefault
public abstract class ConcurrentExpandingMapArrays<K, V> extends ConcurrentExpandingMapBase<K, V, Object[]> {
    @Override
    protected Object[] allocateTable(int size) {
        return new Object[size];
    }

    @Nullable
    @Override
    protected V getFromTable(Object[] table, int idx) {
        return (V) table[idx];
    }

    @Override
    protected int tableLength(Object[] table) {
        return table.length;
    }

    @Override
    protected void setInTable(Object[] table, int idx, V value) {
        table[idx] = value;
    }
}
