package ru.yandex.market.graphouse.search.util;

import java.util.concurrent.atomic.AtomicLongArray;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Maksim Leonov (nohttp@)
 *
 * Works like ConcurrentExpandingMapArrays, but maps values to/from index
 */
@ParametersAreNonnullByDefault
public abstract class ConcurrentExpandingMapToIndex<K, V> extends ConcurrentExpandingMapBase<K, V, AtomicLongArray> {
    public abstract V indexToValueImpl(long idx);

    public abstract long valueToIndexImpl(V val);

    private V indexToValue(long idx) {
        if (idx == 0) {
            return null;
        }
        return indexToValueImpl(idx - 1);
    }

    private long valueToIndex(V val) {
        return valueToIndexImpl(val) + 1;
    }

    @Override
    protected AtomicLongArray allocateTable(int size) {
        return new AtomicLongArray(size);
    }

    @Nullable
    @Override
    protected V getFromTable(AtomicLongArray table, int idx) {
        return indexToValue(table.get(idx));
    }

    @Override
    protected int tableLength(AtomicLongArray table) {
        return table.length();
    }

    @Override
    protected void setInTable(AtomicLongArray table, int idx, V value) {
        table.set(idx, valueToIndex(value));
    }

    @Override
    protected void copyFromTable(AtomicLongArray fromTable, int fromIdx, AtomicLongArray toTable, int toIdx) {
        toTable.set(toIdx, fromTable.get(fromIdx));
    }
}
