package ru.yandex.market.graphouse.server;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.collection.unpacked.arrayList.UnpackedArrayList;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public class MetricBatch {
    private UnpackedArrayList<ResolvedMetric> metrics;
    private long submittedAtTsMillis = System.currentTimeMillis();

    public MetricBatch(int size) {
        this.metrics = ResolvedMetric.f.newWithCapacity(size);
    }

    public UnpackedArrayList<ResolvedMetric> getMetrics() {
        return metrics;
    }

    public long getSubmittedAtMillis() {
        return submittedAtTsMillis;
    }

    public int size() {
        return metrics.size();
    }

    public boolean isEmpty() {
        return metrics.isEmpty();
    }

    public void add(ResolvedMetric metric) {
        metrics.add(metric);
    }
}
