package ru.yandex.market.graphouse.server;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.collection.unpacked.arrayList.UnpackedArrayList;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public class ResolvedMetric implements AnyMetric {
    public static final UnpackedArrayList.Factory<ResolvedMetric> f = new UnpackedArrayList.Factory<>(ResolvedMetric.class);

    public final int stockpileShardId;
    public final long stockpileLocalId;

    public final long tsMillis;
    public final double value;

    public final short stockpileDecimPolicyId;

    ResolvedMetric(int stockpileShardId, long stockpileLocalId, long tsMillis, double value, short stockpileDecimPolicyId) {
        this.stockpileShardId = stockpileShardId;
        this.stockpileLocalId = stockpileLocalId;
        this.tsMillis = tsMillis;
        this.value = value;
        this.stockpileDecimPolicyId = stockpileDecimPolicyId;
    }

    @Override
    public boolean isResolved() {
        return true;
    }
}
