package ru.yandex.market.graphouse.server;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.market.graphouse.search.tree.MetricName;
import ru.yandex.solomon.util.collection.unpacked.arrayList.UnpackedArrayList;
import ru.yandex.stockpile.client.shard.StockpileMetricId;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public class UnresolvedMetric implements AnyMetric {
    static final UnpackedArrayList.Factory<UnresolvedMetric> f = new UnpackedArrayList.Factory<>(UnresolvedMetric.class);

    private final MetricName metric;
    private final long tsMillis;
    private final double value;
    private final short stockpilePolicyId;

    UnresolvedMetric(MetricName metric, long tsMillis, double value, short stockpilePolicyId) {
        this.metric = metric;
        this.tsMillis = tsMillis;
        this.value = value;
        this.stockpilePolicyId = stockpilePolicyId;
    }

    ResolvedMetric asResolved() {
        StockpileMetricId id = metric.getStockpileId();
        return new ResolvedMetric(
            id.getShardId(),
            id.getLocalId(),
            tsMillis,
            value,
            stockpilePolicyId
        );
    }

    boolean isSyncedWithDb() {
        return metric.isFromDb();
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public String toString() {
        return "UnresolvedMetric{" +
            "metric=" + metric +
            ", tsMillis=" + tsMillis +
            ", value=" + value +
            ", stockpilePolicyId=" + stockpilePolicyId +
            '}';
    }
}
