package ru.yandex.market.graphouse.stockpile;

import javax.annotation.ParametersAreNonnullByDefault;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

import ru.yandex.stockpile.client.writeRequest.StockpileShardWriteRequest;
import ru.yandex.stockpile.client.writeRequest.StockpileShardWriteRequestBuilder;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public class StockpilePushBatch implements AutoCloseable {

    private final int metricsCount;
    private final Int2ObjectOpenHashMap<StockpileShardWriteRequest> writesByShard;

    public StockpilePushBatch(Int2ObjectOpenHashMap<StockpileShardWriteRequestBuilder> writesByShard, int metricsCount) {
        var writes = new Int2ObjectOpenHashMap<StockpileShardWriteRequest>(writesByShard.size());
        var it = writesByShard.int2ObjectEntrySet().fastIterator();
        while (it.hasNext()) {
            var entry = it.next();
            writes.put(entry.getIntKey(), entry.getValue().build());
        }
        this.writesByShard = writes;
        this.metricsCount = metricsCount;
    }

    public int size() {
        return metricsCount;
    }

    public Int2ObjectOpenHashMap<StockpileShardWriteRequest> getWritesByShard() {
        return writesByShard;
    }

    @Override
    public void close() {
        for (StockpileShardWriteRequest request : writesByShard.values()) {
            request.close();
        }
    }
}
