package ru.yandex.market.graphouse.stockpile.proxy;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.selfmon.AvailabilityStatus;
import ru.yandex.solomon.staffOnly.annotations.LinkedOnRootPage;
import ru.yandex.stockpile.api.MetricMeta;
import ru.yandex.stockpile.client.shard.StockpileMetricId;
import ru.yandex.stockpile.client.writeRequest.StockpileShardWriteRequest;

/**
 * @author alexlovkov
 */
@LinkedOnRootPage("Graphite Stockpile Client")
public interface GraphiteStockpileClient {

    StockpileMetricId generateMetricId();

    int getTotalShardsCount();

    boolean isFullyReady();

    CompletableFuture<ReadResponse> readOne(ReadRequest request);

    AvailabilityStatus getStatus();

    CompletableFuture<Void> writeData(int shardId, StockpileShardWriteRequest logEntry);

    CompletableFuture<List<MetricMeta>> readMetricsMeta(int shardId, long[] localIds);
}
