package ru.yandex.market.graphouse.stockpile.proxy;

import java.util.Objects;

import ru.yandex.stockpile.client.shard.StockpileMetricId;

/**
 * @author Vladimir Gordiychuk
 */
public class ReadRequest {
    private final StockpileMetricId key;
    private final long fromMillis;
    private final long toMillis;
    private final long deadline;

    public ReadRequest(Builder builder) {
        this.key = Objects.requireNonNull(builder.key);
        this.fromMillis = builder.fromMillis;
        this.toMillis = builder.toMillis;
        this.deadline = builder.deadline;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public StockpileMetricId getKey() {
        return key;
    }

    public long getFromMillis() {
        return fromMillis;
    }

    public long getToMillis() {
        return toMillis;
    }

    public long getDeadline() {
        return deadline;
    }

    public static class Builder {
        private StockpileMetricId key;
        private long fromMillis;
        private long toMillis;
        private long deadline;

        public Builder setKey(StockpileMetricId key) {
            this.key = key;
            return this;
        }

        public Builder setFromMillis(long fromMillis) {
            this.fromMillis = fromMillis;
            return this;
        }

        public Builder setToMillis(long toMillis) {
            this.toMillis = toMillis;
            return this;
        }

        public Builder setDeadline(long deadline) {
            this.deadline = deadline;
            return this;
        }

        public ReadRequest build() {
            return new ReadRequest(this);
        }

    }
}
