package ru.yandex.market.graphouse.stockpile.proxy;

import com.google.common.base.Strings;

import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.stockpile.api.EStockpileStatusCode;
import ru.yandex.stockpile.client.shard.StockpileMetricId;

/**
 * @author Vladimir Gordiychuk
 */
public class ReadResponse {
    private StockpileMetricId metricId;
    private EStockpileStatusCode status;
    private String statusDetails;
    private MetricType dataType;
    private AggrGraphDataIterable source;

    public ReadResponse(StockpileMetricId metricId, EStockpileStatusCode status, String statusDetails) {
        this.metricId = metricId;
        this.status = status;
        this.statusDetails = statusDetails;
        this.dataType = MetricType.METRIC_TYPE_UNSPECIFIED;
        this.source = AggrGraphDataArrayList.empty();
    }

    public ReadResponse(StockpileMetricId metricId, MetricType dataType, AggrGraphDataIterable source) {
        this.metricId = metricId;
        this.status = EStockpileStatusCode.OK;
        this.statusDetails = "";
        this.dataType = dataType;
        this.source = source;
    }

    public StockpileMetricId getMetricId() {
        return metricId;
    }

    public boolean isOk() {
        return status == EStockpileStatusCode.OK;
    }

    public String errorMessage() {
        if (Strings.isNullOrEmpty(statusDetails)) {
            return metricId + " " + status.toString();
        }
        return metricId + " " + status + ": " + statusDetails;
    }

    public AggrGraphDataIterable getSource() {
        return source;
    }

    public MetricType getDataType() {
        return dataType;
    }

    @Override
    public String toString() {
        return "ReadResponse{" +
            "metricId=" + metricId +
            ", status=" + status +
            ", statusDetails='" + statusDetails + '\'' +
            ", source=" + AggrGraphDataArrayList.of(source) +
            '}';
    }
}
