package ru.yandex.market.graphouse.retention;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.util.time.TimeProvider;
import ru.yandex.solomon.util.time.TimeProviderTestImpl;
import ru.yandex.stockpile.api.EDecimPolicy;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class RetentionTest {
    @Test
    public void testNoRetention() {
        TimeProvider provider = new TimeProviderTestImpl();
        Retention retention = new Retention(
            m -> true,
            provider,
            EDecimPolicy.POLICY_KEEP_FOREVER,
            60_000
        );

        Assert.assertEquals(60_000, retention.getStepMillis(provider.nowMillis()));
        Assert.assertEquals(60_000, retention.getStepMillis(provider.nowMillis() - RetentionConstants.MONTH_MILLIS));
        Assert.assertEquals(60_000, retention.getStepMillis(provider.nowMillis() - 3 * RetentionConstants.MONTH_MILLIS));
    }

    @Test
    public void testSingleRetention() {
        TimeProvider provider = new TimeProviderTestImpl();
        Retention retention = new Retention(
            m -> true,
            provider,
            EDecimPolicy.POLICY_5_MIN_AFTER_7_DAYS,
            60_000
        );

        Assert.assertEquals(60_000, retention.getStepMillis(provider.nowMillis()));
        Assert.assertEquals(60_000, retention.getStepMillis(provider.nowMillis() - 4 * RetentionConstants.DAY_MILLIS));
        Assert.assertEquals(300_000, retention.getStepMillis(provider.nowMillis() - RetentionConstants.WEEK_MILLIS));
        Assert.assertEquals(300_000, retention.getStepMillis(provider.nowMillis() - 2 * RetentionConstants.WEEK_MILLIS));
        Assert.assertEquals(300_000, retention.getStepMillis(provider.nowMillis() - RetentionConstants.MONTH_MILLIS));
    }

    @Test
    public void testMultipleRetention() {
        TimeProvider provider = new TimeProviderTestImpl();
        Retention retention = new Retention(
            m -> true,
            provider,
            EDecimPolicy.POLICY_1_MIN_AFTER_1_MONTH_5_MIN_AFTER_3_MONTHS,
            1_000
        );

        Assert.assertEquals(1_000, retention.getStepMillis(provider.nowMillis()));
        Assert.assertEquals(1_000, retention.getStepMillis(provider.nowMillis() - 4 * RetentionConstants.DAY_MILLIS));
        Assert.assertEquals(60_000, retention.getStepMillis(provider.nowMillis() - RetentionConstants.MONTH_MILLIS));
        Assert.assertEquals(60_000, retention.getStepMillis(provider.nowMillis() - 2 * RetentionConstants.MONTH_MILLIS));
        Assert.assertEquals(300_000, retention.getStepMillis(provider.nowMillis() - 3 * RetentionConstants.MONTH_MILLIS));
        Assert.assertEquals(300_000, retention.getStepMillis(provider.nowMillis() - 4 * RetentionConstants.MONTH_MILLIS));
    }
}
