package ru.yandex.market.graphouse.search;

import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.market.graphouse.retention.HardcodedRetentionManager;
import ru.yandex.misc.test.Assert;
import ru.yandex.solomon.config.protobuf.graphite.storage.TMetricDataControllerConfig;
import ru.yandex.solomon.config.thread.StubThreadPoolProvider;


/**
 * @author alexlovkov
 **/
public class MetricDataControllerTest {

    private HardcodedRetentionManager hardcodedRetentionManager;
    private MetricDataController metricDataController;
    private StubThreadPoolProvider threadPoolProvider;

    @Before
    public void init() {
        hardcodedRetentionManager = new HardcodedRetentionManager();
        TMetricDataControllerConfig.Builder config = TMetricDataControllerConfig.newBuilder();
        config.setThreadPoolName("pool");
        threadPoolProvider = new StubThreadPoolProvider();
        metricDataController =
            new MetricDataController(null, null, hardcodedRetentionManager, config.build(),
                threadPoolProvider);
    }

    @After
    public void shutdown() {
        threadPoolProvider.close();
    }

    @Test
    public void oneSecTest() {
        long stepMillis =
            metricDataController.getStepMillis(getIdByMetric("one_sec.metric"), System.currentTimeMillis());
        Assert.assertEquals(TimeUnit.SECONDS.toMillis(1), stepMillis);
    }

    @Test
    public void fiveSecTest() {
        long stepMillis =
            metricDataController.getStepMillis(getIdByMetric("five_sec.metric"), System.currentTimeMillis());
        Assert.assertEquals(TimeUnit.SECONDS.toMillis(5), stepMillis);
    }

    @Test
    public void tenSecTest() {
        long stepMillis =
            metricDataController.getStepMillis(getIdByMetric("ten_sec.metric"), System.currentTimeMillis());
        Assert.assertEquals(TimeUnit.SECONDS.toMillis(10), stepMillis);
    }

    @Test
    public void oneMinTest() {
        long stepMillis =
            metricDataController.getStepMillis(getIdByMetric("one_min.metric"), System.currentTimeMillis());
        Assert.assertEquals(TimeUnit.MINUTES.toMillis(1), stepMillis);
    }

    @Test
    public void fiveMinTest() {
        long stepMillis =
            metricDataController.getStepMillis(getIdByMetric("five_min.metric"), System.currentTimeMillis());
        Assert.assertEquals(TimeUnit.MINUTES.toMillis(5), stepMillis);
    }

    @Test
    public void tenMinTest() {
        long stepMillis =
            metricDataController.getStepMillis(getIdByMetric("ten_min.metric"), System.currentTimeMillis());
        Assert.assertEquals(TimeUnit.MINUTES.toMillis(10), stepMillis);
    }

    @Test
    public void halfHourTest() {
        long stepMillis =
            metricDataController.getStepMillis(getIdByMetric("half_hour.metric"), System.currentTimeMillis());
        Assert.assertEquals(TimeUnit.MINUTES.toMillis(30), stepMillis);
    }

    @Test
    public void oneHourTest() {
        long stepMillis =
            metricDataController.getStepMillis(getIdByMetric("metric.one_hour"), System.currentTimeMillis());
        Assert.assertEquals(TimeUnit.HOURS.toMillis(1), stepMillis);
    }

    @Test
    public void oneDayTest() {
        long stepMillis =
            metricDataController.getStepMillis(getIdByMetric("metric.one_day"), System.currentTimeMillis());
        Assert.assertEquals(TimeUnit.DAYS.toMillis(1), stepMillis);
    }

    private Stream<Short> getIdByMetric(String name) {
        return Stream.of((short) hardcodedRetentionManager.getRetentionIdForMetric(name));
    }
}
