package ru.yandex.market.graphouse.search;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.Test;

import ru.yandex.market.graphouse.search.tree.Dir;
import ru.yandex.market.graphouse.search.tree.DirZip;
import ru.yandex.market.graphouse.search.tree.MetricDescriptionImpl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricDescriptionTest {

    @Test
    public void dirGetName() {
        var dirs = dirs("one", "two", "tree");
        var dir = DirZip.of(dirs);
        var description = description(dirs);
        assertEquals("one.two.tree", dir.getName());
        assertEquals(dir.getName(), description.getName());
    }

    @Test
    public void dirGetStatus() {
        var dirs = dirs("one", "two", "tree");
        var dir = DirZip.of(dirs);
        var description = description(dirs);
        assertEquals(MetricTreeStatus.SIMPLE, dir.getStatus());
        assertEquals(dir.getStatus(), description.getStatus());
    }

    @Test
    public void dirIsDir() {
        var dirs = dirs("one", "two", "tree");
        var dir = DirZip.of(dirs);
        var description = description(dirs);
        assertTrue(dir.isDir());
        assertTrue(description.isDir());
    }

    private MetricDescription description(List<Dir> dirs) {
        return new MetricDescriptionImpl<>(dirs.subList(0, dirs.size() - 1), dirs.get(dirs.size() - 1));
    }

    private List<Dir> dirs(String... dirs) {
        return Stream.concat(Stream.of(new Dir()), Stream.of(dirs).map(Dir::new)).collect(Collectors.toList());
    }
}
