package ru.yandex.market.graphouse.search;

import java.util.concurrent.ThreadLocalRandom;

import ru.yandex.market.graphouse.stockpile.GraphouseStockpileIdGenerator;
import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileMetricId;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class StockpileIdGenForTests implements GraphouseStockpileIdGenerator {

    @Override
    public StockpileMetricId generateMetricId() {
        int shardId = ThreadLocalRandom.current().nextInt(1, 1000);
        return new StockpileMetricId(shardId, StockpileLocalId.random());
    }

    @Override
    public boolean isStockpileIdFromDatabase() {
        return false;
    }
}
