package ru.yandex.market.graphouse.search;

import javax.annotation.Nonnull;

import ru.yandex.market.graphouse.retention.Retention;
import ru.yandex.market.graphouse.retention.RetentionManager;
import ru.yandex.solomon.util.time.TimeProviderImpl;
import ru.yandex.stockpile.api.EDecimPolicy;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class StockpileRetentionManagerForTests implements RetentionManager {
    private static final Retention defaultRetention = defaultRetention();

    @Override
    public byte getRetentionIdForMetric(String metricName) {
        return 0;
    }

    @Nonnull
    @Override
    public Retention getRetentionById(short id) {
        if (id == 0) {
            return defaultRetention;
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static Retention defaultRetention() {
        return new Retention(
            m -> true,
            new TimeProviderImpl(),
            EDecimPolicy.POLICY_KEEP_FOREVER,
            60_000
        );
    }
}
