package ru.yandex.market.graphouse.search.dao.ydb;

import java.util.concurrent.ForkJoinPool;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;

import ru.yandex.devtools.test.annotations.YaExternal;
import ru.yandex.market.graphouse.search.dao.AbstractMetricsDaoTest;
import ru.yandex.market.graphouse.search.dao.MetricsDao;
import ru.yandex.solomon.config.protobuf.Time;
import ru.yandex.solomon.config.protobuf.TimeUnit;
import ru.yandex.solomon.config.protobuf.graphite.storage.TKikimrConfig;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

/**
 * @author Vladimir Gordiychuk
 */
@YaExternal
public class YdbMetricsDaoTest extends AbstractMetricsDaoTest {

    @ClassRule
    public static LocalKikimr kikimr = new LocalKikimr();

    private YdbHelper ydb;
    private YdbMetricsDao dao;

    @Before
    public void init() {
        ydb = new YdbHelper(kikimr, "MegaGraphite");
        dao = createDao();

        dao.createSchemaForTests().join();
    }

    @After
    public void tearDown() {
        ydb.close();
    }

    @Override
    protected MetricsDao getDao() {
        return dao;
    }

    private YdbMetricsDao createDao() {
        var config = TKikimrConfig.newBuilder()
                .setLastUpdateTtl(Time.newBuilder()
                        .setValue(10)
                        .setUnit(TimeUnit.SECONDS))
                .setSchemaRoot(ydb.getRootPath())
                .setLastUpdateTtl(Time.newBuilder().setValue(10).setUnit(TimeUnit.SECONDS))
                .setMaxDeletionInFlight(4)
                .setBatchSize(1000)
                .setMaxSavingInFlight(4)
                .build();
        return new YdbMetricsDao(config, ydb.getTableClient(), ForkJoinPool.commonPool());
    }
}
