package ru.yandex.market.graphouse.search.dao.ydb;

import java.util.List;

import org.junit.Test;

import ru.yandex.market.graphouse.search.dao.ydb.YdbMetricsTable.PrimaryKeyRange;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbMetricsTableTest {

    @Test
    public void rangeSplit() {
        var all = new PrimaryKeyRange(0, 6); // 0 1 2 3 4 5 6

        assertEquals("0 1 2 3 4 5", List.of(new PrimaryKeyRange(0, 6)), all.split(1));

        assertEquals("0 1 2 | 3 4 5", List.of(
                new PrimaryKeyRange(0, 3),
                new PrimaryKeyRange(3, 6)
        ), all.split(2));

        assertEquals("0 1 | 2 3 | 4 5", List.of(
                new PrimaryKeyRange(0, 2),
                new PrimaryKeyRange(2, 4),
                new PrimaryKeyRange(4, 6)
        ), all.split(3));

        assertEquals("0 1 | 2 3 | 4 5", List.of(
                new PrimaryKeyRange(0, 2),
                new PrimaryKeyRange(2, 4),
                new PrimaryKeyRange(4, 6)
        ), all.split(4));

        assertEquals("0 1 | 2 3 | 4 5", List.of(
                new PrimaryKeyRange(0, 2),
                new PrimaryKeyRange(2, 4),
                new PrimaryKeyRange(4, 6)
        ), all.split(5));


        assertEquals("0 | 1 | 2 | 3 | 4 | 5", List.of(
                new PrimaryKeyRange(0, 1),
                new PrimaryKeyRange(1, 2),
                new PrimaryKeyRange(2, 3),
                new PrimaryKeyRange(3, 4),
                new PrimaryKeyRange(4, 5),
                new PrimaryKeyRange(5, 6)
        ), all.split(6));

        assertEquals("0 | 1 | 2 | 3 | 4 | 5", List.of(
                new PrimaryKeyRange(0, 1),
                new PrimaryKeyRange(1, 2),
                new PrimaryKeyRange(2, 3),
                new PrimaryKeyRange(3, 4),
                new PrimaryKeyRange(4, 5),
                new PrimaryKeyRange(5, 6)
        ), all.split(10));
    }

    @Test
    public void rangeNotFromBegin() {
        var all = new PrimaryKeyRange(5, 10); // 5 6 7 8 9

        assertEquals("5 6 7 8 9",List.of(new PrimaryKeyRange(5, 10)), all.split(1));
        assertEquals("5 6 7 | 8 9",List.of(
                new PrimaryKeyRange(5, 8),
                new PrimaryKeyRange(8, 10)),
                all.split(2));
        assertEquals("5 6 | 7 8 | 9",List.of(
                new PrimaryKeyRange(5, 7),
                new PrimaryKeyRange(7, 9),
                new PrimaryKeyRange(9, 10)),
                all.split(3));
    }

    @Test
    public void splitWholeRange() {
        assertEquals(8, PrimaryKeyRange.range().split(8).size());
    }
}
