package ru.yandex.market.graphouse.search.tree;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

import org.apache.commons.compress.utils.Lists;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.stockpile.client.shard.StockpileMetricId;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

/**
 * @author Vladimir Gordiychuk
 */
public class DirTest {

    private Dir dir;

    @Before
    public void setUp() throws Exception {
        dir = new Dir();
    }

    @Test
    public void absentChildDir() {
        assertNull(dir.getDir("child"));
        assertEquals(0, dir.sizeDirs());
        assertEquals(Lists.newArrayList(), Lists.newArrayList(dir.listDirs().iterator()));
    }

    @Test
    public void oneChildDir() {
        var expect = new Dir("child");
        dir.putDirIfAbsent(expect, new ReentrantLock());
        assertEquals(expect, dir.getDir("child"));
        assertEquals(1, dir.sizeDirs());
        assertEquals(List.of(expect), Lists.newArrayList(dir.listDirs().iterator()));
    }

    @Test
    public void oneChildNotMatched() {
        dir.putDirIfAbsent(new Dir("other_child"), new ReentrantLock());
        assertNull(dir.getDir("child"));
        assertEquals(0, dir.sizeMetrics());
        assertEquals(Lists.newArrayList(), Lists.newArrayList(dir.listMetrics().iterator()));
    }

    @Test
    public void multipleChildDir() {
        var alice = new Dir("alice");
        var bob = new Dir("bob");
        dir.putDirIfAbsent(alice, new ReentrantLock());
        dir.putDirIfAbsent(bob, new ReentrantLock());
        assertEquals(alice, dir.getDir("alice"));
        assertEquals(bob, dir.getDir("bob"));
        assertNull(dir.getDir("eva"));
        assertEquals(2, dir.sizeDirs());
    }

    @Test
    public void absentChildMetric() {
        assertNull(dir.getMetric("child"));
    }

    @Test
    public void oneChildMetric() {
        var expect = new MetricName("child", new StockpileMetricId(1, 2), true, (byte) 0);
        dir.putMetricIfAbsent(expect, new ReentrantLock());
        assertEquals(expect, dir.getMetric("child"));

        assertEquals(1, dir.sizeMetrics());
        assertEquals(List.of(expect), Lists.newArrayList(dir.listMetrics().iterator()));
    }

    @Test
    public void oneChildMetricNotMatched() {
        var expect = new MetricName("other_child", new StockpileMetricId(1, 2), true, (byte) 0);
        dir.putMetricIfAbsent(expect, new ReentrantLock());
        assertNull(dir.getMetric("child"));
    }

    @Test
    public void multipleChildMetric() {
        var alice = new MetricName("alice", new StockpileMetricId(1, 2), true, (byte) 0);
        var bob = new MetricName("bob", new StockpileMetricId(1, 3), true, (byte) 0);
        dir.putMetricIfAbsent(alice, new ReentrantLock());
        dir.putMetricIfAbsent(bob, new ReentrantLock());
        assertEquals(alice, dir.getMetric("alice"));
        assertEquals(bob, dir.getMetric("bob"));
        assertNull(dir.getMetric("eva"));
        assertEquals(2, dir.sizeMetrics());
    }
}
