#pragma once

#include "events.h"
#include "slots.h"

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/threading/future/future.h>

namespace NSolomon {

struct TCommonEvents: public TEventSlot<EEventSpace::Libs, ELibSlot::Common> {
    enum {
        Poison = SpaceBegin,
        End,
    };

    static_assert(End < SpaceEnd, "too many event types");

    class TAsyncPoison: public NActors::TEventLocal<TAsyncPoison, Poison> {
    public:
        TAsyncPoison()
            : Promise_(NThreading::NewPromise())
        {
        }

        NThreading::TFuture<void> Future() const {
            return Promise_.GetFuture();
        }

        void Done() {
            Promise_.SetValue();
        }

        void Error(const TString& message) {
            Promise_.SetException(message);
        }

        void Error(const std::exception_ptr& e) {
            Promise_.SetException(e);
        }

    private:
        NThreading::TPromise<void> Promise_;
    };
};

} // namespace NSolomon
