#pragma once

#include <library/cpp/actors/core/events.h>

#include <util/generic/cast.h>
#include <util/generic/utility.h>

namespace NSolomon {

// Each event space can have up to 2^16 - 1 events
enum class EEventSpace: int {
    Private = NActors::TEvents::ES_PRIVATE,
    Libs = NActors::TEvents::ES_USERSPACE,
    Fetcher,
    Ingestor,
    LoadInfo,
    ClusterMembership,
    DataProxy,
    MemStore,
    Slicer,
    // <-- add new space here
};

// Each slot can have up to 64 events, so you can use up to 1024 slots per space
template <EEventSpace Space, size_t Slot>
class TEventSlot {
    static constexpr size_t Size = 64;

public:
    static constexpr size_t SpaceBegin = EventSpaceBegin(ToUnderlying(Space)) + Slot * Size;
    static constexpr size_t SpaceEnd = Min<size_t>(Size + SpaceBegin, EventSpaceEnd(ToUnderlying(Space)));
};

// Special case for private events (no need to divide by slots)
class TPrivateEvents: public TEventSlot<EEventSpace::Private, 0> {
};

} // namespace NSolomon
