#pragma once

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/actors/interconnect/proto/ic_config.pb.h>

#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NMonitoring {
    struct TDynamicCounters;
} // namespace NMonitoring

namespace NSolomon {
    struct TIcEndpoint {
        TString Hostname;
        TString Address;
        ui16 Port{0};
        ui32 NodeId{0};
    };

    struct TInterconnectConfig {
        ui32 ThisNodeId{0};
        TVector<TIcEndpoint> Endpoints;
    };

    void InitInterconnect(
        NActors::TActorSystemSetup& setup,
        TInterconnectConfig config,
        const std::shared_ptr<NMonitoring::TMetricRegistry>& metrics
    );

    void InitInterconnect(
        NActors::TActorSystemSetup& setup,
        NProto::TInterconnectConfig config,
        std::shared_ptr<NMonitoring::TMetricRegistry> metrics
    );
} // namespace NSolomon
