#include "actor_runtime_metrics.h"
#include "self_ping.h"
#include "threadpool_metrics.h"
#include "threadpool_metrics_collector.h"

#include <library/cpp/actors/core/process_stats.h>

using namespace NActors;
using namespace NMonitoring;

namespace NSolomon {

void AddActorRuntimeMetrics(TActorRuntime& actorRuntime, TMetricRegistry& registry) {
    actorRuntime.Register(CreateProcStatCollector(TDuration::Seconds(15), registry));

    std::vector<TTreadPoolMetrics> metricsByPool;
    for (ui32 id = 0; id < actorRuntime.ExecutorsSize(); id++) {
        auto name = actorRuntime.ExecutorName(id);
        auto* metric = registry.IntGauge({{"sensor", "actors.threads.selfPingUs"}, {"id", name}});
        actorRuntime.Register(CreateLatencyActor(TDuration::MilliSeconds(10), metric), TMailboxType::Simple, id);
        metricsByPool.emplace_back(registry, name);
    }

    actorRuntime.Register(CreateThreadPoolMetricCollector(TDuration::Seconds(15), metricsByPool));
}
} // namespace NSolomon
