#include "self_ping.h"


#include <library/cpp/monlib/metrics/metric.h>
#include <library/cpp/sliding_window/sliding_window.h>

using namespace NActors;
using namespace NMonitoring;

namespace NSolomon {
namespace {

class TLatencyActor: public TSelfPingActor<TLatencyActor> {
public:
    TLatencyActor(TDuration interval, TIntGauge* metric) noexcept
        : TSelfPingActor<TLatencyActor>{interval}
        , Metric_{metric}
        , Window_{TDuration::Seconds(15), 100}
    {
    }

    void OnPing(TInstant now, TInstant pingStart) {
        const auto duration = now - pingStart;
        Metric_->Set(Window_.Update(duration.MicroSeconds(), now));
    }

private:
    TIntGauge* Metric_;
    NSlidingWindow::TSlidingWindow<NSlidingWindow::TMaxOperation<i64>> Window_;
};

class TUptimeActor: public TSelfPingActor<TUptimeActor> {
public:
    explicit TUptimeActor(ICounter* metric) noexcept
        : TSelfPingActor<TUptimeActor>{TDuration::Seconds(15)}
        , Metric_{metric}
    {
    }

    void OnPing(TInstant now, TInstant pingStart) const {
        Metric_->Add((now - pingStart).MilliSeconds());
    }

private:
    ICounter* Metric_;
};

} // namespace

std::unique_ptr<IActor> CreateLatencyActor(TDuration interval, TIntGauge* metric) {
    return std::make_unique<TLatencyActor>(interval, metric);
}

std::unique_ptr<IActor> CreateUptimeActor(ICounter* metric) {
    return std::make_unique<TUptimeActor>(metric);
}

} // namespace NSolomon
